/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.integration.jei;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.common.container.BlastFurnaceContainer;
import dev.toma.gunsrpg.common.container.CookerContainer;
import dev.toma.gunsrpg.common.container.CulinaryTableContainer;
import dev.toma.gunsrpg.common.container.MedstationContainer;
import dev.toma.gunsrpg.common.container.SmithingTableContainer;
import dev.toma.gunsrpg.common.init.ModBlocks;
import dev.toma.gunsrpg.common.init.ModRecipeTypes;
import dev.toma.gunsrpg.integration.jei.AmmoBenchRecipeCategory;
import dev.toma.gunsrpg.integration.jei.BurningRecipeCategory;
import dev.toma.gunsrpg.integration.jei.SkilledRecipeCategory;
import dev.toma.gunsrpg.resource.blasting.BlastingRecipe;
import dev.toma.gunsrpg.resource.cooking.CookingRecipe;
import dev.toma.gunsrpg.resource.crafting.CulinaryRecipe;
import dev.toma.gunsrpg.resource.crafting.MedRecipe;
import dev.toma.gunsrpg.resource.crafting.SmithingRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class JeiIntegration
implements IModPlugin {
    public static final ResourceLocation PLUGIN_UID = GunsRPG.makeResource("jei");
    public static final ResourceLocation SMITHING = GunsRPG.makeResource("smithing");
    public static final ResourceLocation CULINARY = GunsRPG.makeResource("culinary");
    public static final ResourceLocation MEDSTATION = GunsRPG.makeResource("medstation");
    public static final ResourceLocation BLASTING = GunsRPG.makeResource("blasting");
    public static final ResourceLocation COOKING = GunsRPG.makeResource("cooking");
    public static final ResourceLocation AMMO_BENCH = GunsRPG.makeResource("ammo_bench");

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper helper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new BurningRecipeCategory<BlastingRecipe>(helper, BLASTING.func_110623_a(), ModBlocks.BLAST_FURNACE, 800, BlastingRecipe.class), new BurningRecipeCategory<CookingRecipe>(helper, COOKING.func_110623_a(), ModBlocks.COOKER, 200, CookingRecipe.class), new SkilledRecipeCategory(helper, SMITHING.func_110623_a(), ModBlocks.SMITHING_TABLE, SmithingRecipe.class), new SkilledRecipeCategory(helper, CULINARY.func_110623_a(), ModBlocks.CULINARY_TABLE, CulinaryRecipe.class), new SkilledRecipeCategory(helper, MEDSTATION.func_110623_a(), ModBlocks.MEDICAL_STATION, MedRecipe.class), new AmmoBenchRecipeCategory(helper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeFetcher fetcher = new RecipeFetcher();
        registration.addRecipes(fetcher.getRecipes(ModRecipeTypes.COOKING_RECIPE_TYPE), COOKING);
        registration.addRecipes(fetcher.getRecipes(ModRecipeTypes.BLASTING_RECIPE_TYPE), BLASTING);
        registration.addRecipes(fetcher.getRecipes(ModRecipeTypes.SMITHING_RECIPE_TYPE), SMITHING);
        registration.addRecipes(fetcher.getRecipes(ModRecipeTypes.CULINARY_RECIPE_TYPE), CULINARY);
        registration.addRecipes(fetcher.getRecipes(ModRecipeTypes.MED_RECIPE_TYPE), MEDSTATION);
        registration.addRecipes(fetcher.getRecipes(ModRecipeTypes.AMMO_BENCH_RECIPE_TYPE), AMMO_BENCH);
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(CookerContainer.class, COOKING, 0, 1, 3, 36);
        registration.addRecipeTransferHandler(BlastFurnaceContainer.class, BLASTING, 0, 1, 3, 36);
        registration.addRecipeTransferHandler(SmithingTableContainer.class, SMITHING, 0, 9, 9, 36);
        registration.addRecipeTransferHandler(CulinaryTableContainer.class, CULINARY, 0, 9, 9, 36);
        registration.addRecipeTransferHandler(MedstationContainer.class, MEDSTATION, 0, 9, 9, 36);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.COOKER), new ResourceLocation[]{COOKING});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.BLAST_FURNACE), new ResourceLocation[]{BLASTING});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.SMITHING_TABLE), new ResourceLocation[]{SMITHING});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.CULINARY_TABLE), new ResourceLocation[]{CULINARY});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.MEDICAL_STATION), new ResourceLocation[]{MEDSTATION});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.AMMO_BENCH), new ResourceLocation[]{AMMO_BENCH});
    }

    public ResourceLocation getPluginUid() {
        return PLUGIN_UID;
    }

    public static class RecipeFetcher {
        private final ClientWorld level;

        public RecipeFetcher() {
            this.level = Objects.requireNonNull(Minecraft.func_71410_x().field_71441_e);
        }

        public <I extends IInventory, T extends IRecipe<I>> List<T> getRecipes(IRecipeType<T> type) {
            return this.getRecipesByType(this.level.func_199532_z(), type);
        }

        public <I extends IInventory, T extends IRecipe<I>> List<T> getRecipesByType(RecipeManager manager, IRecipeType<T> type) {
            Map recipeMap = manager.func_215366_a(type);
            return new ArrayList(recipeMap.values());
        }
    }
}

